/* compdir.c: part of the spbackup - programm
 *
 * written by: steffen pohle <steffen@gulpe.de>
 * date: 2013-07-30
 *
 */

#include "backup.h"

int compdir (int nr, char *src, char *dst, char *relpath, int callback(int, char *, struct stat *, char *, struct stat *)) {
	DIR *srcdir;
	struct dirent *entry;
	struct stat sbuf, dbuf;
	int si, di, cb_stat, cb_ret;
	char curpath[PATHNAME_LEN];
	char srcfn[PATHNAME_LEN];
	char dstfn[PATHNAME_LEN];
	char path[PATHNAME_LEN];

	if ((debug & DBG_NOCHECK) == 0) 
		printf ("check%d: %s\n", nr, relpath);

	str_delslash (src);
	str_delslash (dst);
	if (relpath == NULL) {
		curpath[0] = DIR_SLASH;
		curpath[1] = '\0';
	}
	else {
		strncpy (curpath, relpath, PATHNAME_LEN);
		str_delslash (curpath);
		curpath[strlen(curpath)+1] = '\0';
		curpath[strlen(curpath)] = DIR_SLASH;
	}

	snprintf (path, PATHNAME_LEN, "%s%s", src, curpath);

	srcdir = opendir (path);
	if (srcdir == NULL) {
		printf ("%s:%d '%s' ERROR:%s \n", __FILE__, __LINE__, path, strerror(errno));
		return 0;
	}

	for (entry = readdir (srcdir) ;entry != NULL; entry = readdir (srcdir)) {
		if (strcmp (entry->d_name, ".") == 0 || strcmp(entry->d_name, "..") == 0) continue;
		snprintf (dstfn, PATHNAME_LEN, "%s%s%s", dst, curpath, entry->d_name);
		snprintf (srcfn, PATHNAME_LEN, "%s%s%s", src, curpath, entry->d_name);
		cb_stat = 0;

		if (entry->d_type == DT_DIR || entry->d_type == DT_REG || entry->d_type == 0) {
			di = stat (dstfn, &dbuf);
			if (di != 0) {
				if (errno == EACCES) {
					printf ("%s:%d access denied on: %s\n", __FILE__, __LINE__, dstfn);
					printf ("file:%s%s\n", curpath, entry->d_name);
					continue;
				}
				cb_stat |= CDR_NODEST;
			}

			si = stat (srcfn, &sbuf);
			if (si != 0) {
				//			if (errno == EACCES) {
				printf ("%s:%d error:%s   %s\n", __FILE__, __LINE__, srcfn, strerror(errno));
				printf ("file:%s%s\n", curpath, entry->d_name);
				//			}
				continue;
			}
			if (S_ISDIR(sbuf.st_mode)) cb_stat |= CDR_ISDIR;
			if (S_ISREG(sbuf.st_mode)) {
				cb_stat |= CDR_ISFILE;
			}

			if ((cb_stat & CDR_NODEST) == 0) {
				if (dbuf.st_size != sbuf.st_size) cb_stat |= (CDR_DIFFSIZE + CDR_ISDIFF);
				if (dbuf.st_mtime != sbuf.st_mtime) cb_stat |= (CDR_DIFFDATE + CDR_ISDIFF);
				if (dbuf.st_mode != sbuf.st_mode) cb_stat |= (CDR_DIFFMODE + CDR_ISDIFF);
				if (dbuf.st_uid != sbuf.st_uid || dbuf.st_gid != sbuf.st_gid)
					cb_stat |= (CDR_DIFFOWNER + CDR_ISDIFF);
			}

			cb_ret = callback (cb_stat, dstfn, &dbuf, srcfn, &sbuf);
			if ((cb_stat & CDR_ISDIR) && cb_ret == CDCB_RECURSIVE) {
				char temp[PATHNAME_LEN];
				snprintf (temp, PATHNAME_LEN, "%s%s", curpath, entry->d_name);
				compdir (nr, src, dst, temp, callback);
			}
		}
		else if (entry->d_type == DT_LNK) {
			int len;
			char slnk[PATHNAME_LEN];
			char dlnk[PATHNAME_LEN];
			cb_stat |= CDR_ISLINK;

			len = readlink(srcfn, slnk, PATHNAME_LEN);
			if (len < 0) {
				printf ("%s:%d error reading link '%s' %s\n", __FILE__, __LINE__, srcfn, strerror (errno));
				slnk[0] = 0;
			}
			else slnk[len] = 0;

			len = readlink(dstfn, dlnk, PATHNAME_LEN);
			if (len <= 0) {
				if (errno == ENOENT) {
					cb_stat |= CDR_NODEST;
				}
				else {
					printf ("%s:%d error reading link '%s' %s\n", __FILE__, __LINE__, dstfn, strerror (errno));
				}
				dlnk[0] = 0;
			}
			else dlnk[len] = 0;
			if (strncmp (slnk, dlnk, PATHNAME_LEN) != 0)
				cb_stat |= CDR_ISDIFF;

			cb_ret = callback (cb_stat, dstfn, NULL, srcfn, NULL);
		}
	}

	closedir (srcdir);

	return 0;
};


/*
 * delete last slash
 */
void str_delslash (char *path) {
	int i = strlen (path);

	while (i > 0 && path[i-1] == DIR_SLASH) {
		path[i-1] = '\0';
		i--;
	}
};

