/* backup.h: part of the spbackup - programm
 *
 * written by: steffen pohle <steffen@gulpe.de>
 * date: 2013-07-30
 *
 */


#ifndef _BACKUP_H_
#define _BACKUP_H_

#define _FILE_OFFSET_BITS 64

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <utime.h>
#include <unistd.h>

#define DIR_SLASH '/'
#define PATHNAME_LEN 512

#define CDR_DIFFSIZE  0x0001
#define CDR_DIFFDATE  0x0002
#define CDR_DIFFMODE  0x0004
#define CDR_DIFFOWNER 0x0008

#define CDR_NODEST  0x0010

#define CDR_ISDIR	0x0100
#define CDR_ISFILE	0x0200
#define CDR_ISDIFF	0x0400
#define CDR_ISLINK	0x0800

#define CDCB_NEXT		0x01
#define CDCB_RECURSIVE	0x02

#define CMD_IGNORE_OWNER 0x0001
#define CMD_IGNORE_MODE  0x0002

#define CMD_COPY     0x0004
#define CMD_REMOVE   0x0008
#define CMD_FIXMODE  0x0010
#define CMD_FIXOWNER 0x0020
#define CMD_FIXDATE  0x0040
#define DBG_NOCHECK 0x0001

extern int debug;

extern int compdir (int nr, char *src, char *dst, char *relpath, int callback(int , char *, struct stat *, char *, struct stat *));
extern void str_delslash (char *path);

#endif // _BACKUP_H_

